% Author: Layla S. Mayboudi
% 2021-05-27
% This code calculates the thermal diffusivity using the inputted thermo-physical properties:
% (density, thermal conductivity, and heat capacity).


function therm = ThermalCond ()
    var1 = input ('Density (kg/m3)= \n'); %kg/m3
    var2 = input ('Thermal conductivity (W/mk)= \n'); %W/mk
    var3 = input ('Heat capacity (J/kgK)= \n'); %J/kgK
    display(blanks(1))
        if  var1 > 2800 %kg/m3                
                disp ('The selected material is too dense.')
        else
                if  var1 < 1000 %kg/m3                
                disp ('The selected material is not dense enough.')
                else                    
                    disp ('Density meets the critera.')
                end                        
                if  var2 < 900 %W/mk                
                disp ('The selected material is not conductivie enough.')
                else
                    if  var2 > 3000 %kg/m3
                    disp ('The selected material is too conductive.')
                    end                
                        disp ('Thermal conductivity meets the criteria.')
                end     
        end
        display(blanks(1))
       if  and(1500 < var1,var1 < 2500);
            if and(900 < var2,var2 < 3000);                
                disp ('The selected material meets the criteria.') 
            end;        
        else            
                disp ('The selected material does not meet the criteria.') 
       end;
        display(blanks(1))
        alpha = var2/(var1*var3); %m2/s        
        name1 = 'Density (kg/m3)'; name2 = 'Thermal conductivity (W/mK)';
        name3 = 'Heat capacity (J/kgK)'; name4 = 'Thermal diffusivity (m2/s)';
        display(blanks(2))
        fprintf('%s = %d \n',name1,var1); fprintf('%s = %d \n',name2,var2);
        fprintf('%s = %d \n',name3,var3); fprintf('%s = %d \n',name4,alpha);
end
